<?php
/*
Plugin Name: F8EOZ Post Index
Plugin URI: http://www.f8eoz.com
Description: Related posts index plugin. Filter: category name.
Author: F8EOZ Bernard Decaestecker
Version: 1.0 03/02/2013 19:00
Author URI: http://www.f8eoz.com
*/

//Editable constant
define('F8EOZPOSTINDEX_TITLE', '<p><B>Index des articles de la cat&eacute;gorie ${category}</B></p>');
define('F8EOZPOSTINDEX_LINE', '<li><a href="${permalink}" target="_blank">${title}</a></li>');
define('F8EOZPOSTINDEX_BEFORE_LINES', '<ul>');
define('F8EOZPOSTINDEX_AFTER_LINES', '</ul>');
define('F8EOZPOSTINDEX_ORDER', 'ASC');
define('F8EOZPOSTINDEX_ORDERBY', 'title');
define('F8EOZPOSTINDEX_POSTS_PER_PAGE', -1); //all posts, no limit

//Not editable constant
define('F8EOZPOSTINDEX_PLUGIN_NAME', 'f8eoz_post_index');
define('F8EOZPOSTINDEX_PLUGIN_BASENAME', plugin_basename(__FILE__));
define('F8EOZPOSTINDEX_PLUGIN_DIR', dirname(F8EOZPOSTINDEX_PLUGIN_BASENAME));
define("F8EOZPOSTINDEX_SHORTCODE", 'f8eoz_post_index');

//Tag samples
//[f8eoz_post_index category="Blog"] index of category "Blog"
//[f8eoz_post_index] index of category of current post

class PostIndex {
	private $title;
	private $categoryName;
	private $line;
	private $beforeLines;
	private $afterLines;
	private $order;
	private $orderby;
	private $postsPerPage;

	function __construct($title, $line, $beforeLines, $afterLines, $order, $orderby, $postsPerPage) {
		$this->title = $title;
		$this->line = $line;
		$this->beforeLines = $beforeLines;
		$this->afterLines = $afterLines;
		$this->order = $order;
		$this->orderby = $orderby;
		$this->postsPerPage = $postsPerPage;
	}

	function getCategoryName() {
		return $this->categoryName;
	}
	
	function getIndexTitle() {
		return $this->title;
	}
	
	function setIndexTitle($title) {
		$this->$title = $title;
	}

	function parse($category_name) {
		if(empty($category_name)) {
			$categories = get_the_category( get_the_ID() ); //get catagories of current post
			if( !empty($categories) ) {
	            $this->categoryName = $categories[0]->cat_name; //default = get 1st catagory_name
				return;
			}
		}
		$this->categoryName = $category_name; //other = specified category
	}

	function printIndex() {
		if(is_null($this->categoryName)) //no category, no index
		return;
		
		echo "\n<!-- INDEX GENERATED BY f8eoz_post-index --> \n";

		if(!empty($this->title)) {
			echo str_replace( '${category}', $this->categoryName, $this->title );
		}

		$args = array( 	'order'=> $this->order, 
						'orderby' => $this->orderby, 
						'posts_per_page' => $this->postsPerPage, 
						'category_name' => $this->getCategoryName());
		
		echo $this->beforeLines;
		// The Query
		query_posts( $args );
		// The Loop
		while ( have_posts() ) : the_post();
			echo str_replace( '${permalink}'
							, get_Permalink()
							, str_replace( '${title}'
							, get_the_title(), $this->line )
							);
		endwhile;
		// Reset Query
		wp_reset_query();
		echo $this->afterLines;

		echo "\n<!-- END INDEX GENERATED BY f8eoz_post-index --> \n";
	}
}

// ==========================================================================
// Runs after WordPress has finished loading but before any headers are sent. 
 add_action('init', 'f8eoz_post_index');
// ==========================================================================

function f8eoz_post_index() {
	//should be made during init
	load_plugin_textdomain( F8EOZPOSTINDEX_PLUGIN_NAME, false, F8EOZPOSTINDEX_PLUGIN_DIR );

	if(!is_admin()) {
		function f8eoz_post_index_func( $atts ) {
			//create a new instance of object PostIndex with initial properties
			$pi = new PostIndex(F8EOZPOSTINDEX_TITLE, 
								F8EOZPOSTINDEX_LINE, 
								F8EOZPOSTINDEX_BEFORE_LINES, 
								F8EOZPOSTINDEX_AFTER_LINES,
								F8EOZPOSTINDEX_ORDER,
								F8EOZPOSTINDEX_ORDERBY,
								F8EOZPOSTINDEX_POSTS_PER_PAGE);
/*
			Combines user shortcode attributes with known attributes and fills in defaults when needed. 
			The result will contain every key from the known attributes, 
			merged with values from shortcode attributes.
			Usage
			shortcode_atts( $pairs , $atts );
			Parameters
			$pairs :(array) (required) Entire list of supported attributes and their defaults
			Default: None 
			$atts : (array) (required) User defined attributes in shortcode tag
			Default: None 
			Return Values (array) Combined and filtered attribute list. 		
*/
			extract( shortcode_atts( array ( 'category' => null ) , $atts ) ); //extract tag
 			$pi->parse($category); //parse tag
       
			ob_start();	//store post data in buffer
			$pi->printIndex();
			$content = ob_get_contents();
			ob_end_clean();
			return $content;
		}
		add_shortcode(F8EOZPOSTINDEX_SHORTCODE, 'f8eoz_post_index_func');
	
	}
}

?>