<?php 
// Contenu
function wpl_content(){ ?>
	<div id="content">
		<?php if (have_posts()) : ?> <!-- si post -->
			<?php while (have_posts()) : the_post(); ?> <!-- boucle post -->
				<div class="post" id="post-<?php the_ID(); ?>"><!-- dbut du post -->
					<div class="navigation">
						<?php if ( is_single() ) :  /* si article: article prcdent ou suivant  */ ?>				
							<span class="alignleft" ><?php previous_post_link('&laquo; %link') ?></span>
							<span class="alignright"><?php next_post_link('%link &raquo;') ?></span>
						<?php endif ?>	<!-- fin if single -->
					</div>
					<div style="clear:both"></div>
					<!-- Titre du post -->
					<h2 class="posttitle">
						<a href="<?php the_permalink() ?>" rel="bookmark" title="<?php _e('Lien permanent vers', 'f8eoz'); ?> <?php the_title(); ?>">  <?php the_title(); ?></a>
					</h2>
					<!-- Date et heure -->
					<div class="postmetadata">
						<?php the_time('l j F Y') ?>  <?php the_time('H:i:s') ?>
						<!-- Date et heure dernire modification le cas chant V1.3.8 13/05/2013 -->
						<?php
						$publication_time = get_the_time('U');
						$modification_time = get_the_modified_time('U');
						if($publication_time != $modification_time) {
							_e(' - Modifi&eacute; le ', 'f8eoz'); the_modified_time('l j F Y H:i:s');
						} ?>
					</div>
					<!-- Contenu du post - Ici on traite la balise More insre dans le post-->
					<div class="postcontent">
						<?php if ( is_home() || is_page() || is_single() ) :  /* si page  ou article */ ?>				
							<?php the_content(__('Lire la suite... ', 'f8eoz')); ?>
							<?php if (is_page() || is_single() ) : // pagination
								wp_link_pages(array('before' => __('<p><strong>Pages:</strong>', 'f8eoz') , 'after' => '</p>', 'next_or_number' => 'number')); 
							 endif ?>	<!-- fin page -->
						<?php else :  // sinon afficher un extrait de l'article?>
							<?php the_excerpt(); ?>
							<?php link_pages('<p><strong>Pages:</strong> ', '</p>', 'number'); ?>
						<?php endif ?>	<!-- fin page -->
					</div>
					<div class="postmetadata">
						<?php if( function_exists('the_tags') ) : ?>
							<div><?php the_tags(__('Tags: ', 'f8eoz'), ', ', '');?></div>
						<?php endif; ?>	<!-- fin si tag -->
						<?php _e('Cat&eacute;gories: ', 'f8eoz'); ?> <?php the_category(', ') ?> 
						| <?php comments_popup_link(__('Aucun Commentaire', 'f8eoz'), __('1 Commentaire', 'f8eoz'), __('% Commentaires', 'f8eoz')); ?>
						| <?php edit_post_link(__('Modifier', 'f8eoz'), ' &#8212; ', ''); ?>
					</div>
				</div><!-- fin du post -->

				<?php if ( is_single() ) { // si article ?> 
					<div id="social" class="alignleft">
						<?php get_template_part('social', 'single'); // afficher les icnes?>
					</div><!-- end social -->
					<div style="clear:both"></div><!-- met le reste de la page dessous -->
					<?php comments_template(); //afficher les commentaires 
				} /* fin si article:  */ ?>				

				<?php endwhile; ?> <!-- fin boucle post -->
			<div class="navigation">
				<?php if ( is_single() ) :  /* si article: article prcdent ou suivant  */ ?>				
					<span class="alignleft" ><?php previous_post_link('&laquo; %link') ?></span>
					<span class="alignright"><?php next_post_link('%link &raquo;') ?></span>
				<?php else :  // sinon page suivante prcdente ?>
					<span class="alignleft" ><?php previous_posts_link(__('&laquo; Page pr&eacute;c&eacute;dente', 'f8eoz')) ?></span>
					<span class="alignright"><?php next_posts_link(__('Page suivante &raquo;', 'f8eoz')) ?></span>
				<?php endif ?>	<!-- fin if single -->
			</div>
		<?php else : ?> <!-- si non post -->
			<div class="post">
				<h2 class="posttitle"><?php _e('Non trouv&eacute;', 'f8eoz') ?></h2>
				<div class="postentry"><p><?php _e('D&eacute;sol&eacute;, aucune publications correspond &agrave; votre recherche.', 'f8eoz'); ?></p></div>
			</div>
		<?php endif; ?>	<!-- fin si post -->
	</div><!--END CONTENT-->

<?php } // end wpl_content ?>