;******************************************************************************
; File Name    	: chargePIC16F88_led.asm
; Version      	: 1.0
; Title:       	: BLINK LED TEST  and USART Bootloader
; Author		: F8EOZ Bernard DECAESTECKER http://f8eoz.com
; MCU			: Written and Tested on Microchip PIC 16F88 Microcontroller
; Compiler     	: Microchip MPASM Assembler V5.51
; IDE          	: Microchip MPLAB IDE v8.92
; Programmer   	: Home made
; Last Updated 	: 11 October 2015
; *******************************************************************
; Hardware:     
;  Tested with PIC16F88 at 4Mhz  internal oscillator.       
;  USART use pin 8 as RX (RB2) 
;  USART use pin 11 as TX (RB5) 
; *******************************************************************
; Description: 
; *******************************************************************
; BLoader is a small piece of firmware, stored in bottom of
; microcontroller's memory, which can write to the EEPROM of 
; that microcontroller. 
; It uses simple generic asynchronous half-duplex communication protocol:
; LOGIN		     0x01
; WRITE_PROG	 0x02
; WRITE_EEPROM   0x04
; READ_PROG	     0x08
; READ_EEPROM    0x10
; ERASE_PROG	 0x20
; LOGOUT		 0x80
; PARAMETERS see below:
;   Settle depending on PIC
;   EEPROM_SIZE : Maximum EEPROM bytes
;   PROG_MEM_SIZE : FLASH PROGRAM bytes
;
;   Choose your Baud Rate with these parameters below:
;	SPBRG_VALUE : Baud Rate
;	SPBRG_BRGH : High or Low speed Baud Rate
;
;   Choose your Login Timeout with these parameters below:
;   BLOADER_TIMER1_OVF  Overflow TIMER1 counter for login timeout
;   BLOADER_TIMER1	Base TIMER1 value
;   BLOADER_T1CKPS  Prescale value
; *******************************************************************
; Erase/Write note:
; 16F88 requires explicit 32 words block erase and then 4 words block write
;
; Bootloader Mapping:
; x000 - 0x01F: Offset: reset segment
; xF00 - 0xFFF: Bootloader
; x020 - 0xEFF: User Application

;====================================================================== 	
;====================================================================== 	
;====================================================================== 	
;====================================================================== 	

;------------------------- 	
; PIC DEVICE & FUSE
	errorlevel -302	; Turn off banking message known tested (good) code
	errorlevel +302	; Enable banking message untested code
	errorlevel -306	; Turn off Crossing page boundary -- ensure page bits are set
	;errorlevel +306	; Enable Crossing page boundary -- ensure page bits are set
	radix DEC

	TITLE "chargePIC16F88_led.asm"
	list p=16f88	
	#include <p16f88.inc>

	__CONFIG    _CONFIG1, _INTRC_IO  & _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
	__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

;------------------------- 	
; Memory PIC features
PROG_MEM_SIZE = 0x1000 ; 4K FLASH PROGRAM
EEPROM_SIZE = H'100' ; EEPROM = 256 bytes

;------------------------- 	
; Programm Vector  Address
RESET_VECTOR	EQU	0x0000	; Address of RESET Vector
ISR_VECTOR		EQU	0x0004	; Address of Interrupt Vector
BANK0_RAM_DATA	EQU	0x0020	; 16 General Purpose registers (SRAM)
COMMON_RAM_DATA	EQU	0x0070	; 16 General Purpose registers (SRAM)
EEPROM_DATA		EQU	0x2100	; EEPROM address 

;-----------------------------------
; SPRG: BAUD RATE GENERATOR REGISTER
; FOSC  = 4MHz XTAL
; SPBRG = (FOSC/(Desired Baud Rate*16))  1	
; SPBRG = (4000000/(9600*16))  1 = 25,04 = 25
; Calculated Baud Rate = 4000000/(16 * (25+1)) = 9615,38 bauds
; Error = (9615,38  9600) / 9600 = 0,16% <	4%
SPBRG_VALUE = D'25'
SPBRG_BRGH = 1

;====================================================================== 	
;====================================================================== 	
; USER RAM FILES
;====================================================================== 	
;====================================================================== 	

	cblock BANK0_RAM_DATA
	;-------------------- 	
	; Delay count Files
	cmpt1 : 1			
	cmpt2 : 1			
	cmpt3 : 1	
	blinkF: 1
	;---------------- 	
	; Interrupt Files
	ISRwreg:1			; save WREG
	ISRstatus:1			; save STATUS
	endc				; End of General Purpose registers                     

	cblock COMMON_RAM_DATA
	;--------------------- 	
	endc				; End of General Purpose registers                     

;====================================================================== 	
;====================================================================== 	
; END RAM FILES
;====================================================================== 	
;====================================================================== 	


;---------------------------------------------------------------------- 	
; BOOTLOADER RESET SEGMENT RESERVED 32 WORDS
;---------------------------------------------------------------------- 	
BLOADER_OFFSET	EQU 0x20

	ORG 	RESET_VECTOR
	goto	RESET_VECTOR+BLOADER_OFFSET

	; interrupt vector
	ORG		ISR_VECTOR    
	goto	RESET_VECTOR+BLOADER_OFFSET+4

;---------------------------------------------------------------------- 	
; END BOOTLOADER RESET SEGMENT RESERVED 32 WORDS
;---------------------------------------------------------------------- 	

;---------------------------------------------------------------------- 	
; USER APPLICATION SEGMENT
;---------------------------------------------------------------------- 	

; Re-mapped Reset Vector
	ORG		RESET_VECTOR+BLOADER_OFFSET
UserReset
	goto	UserStart

; Re-mapped Interrupt Vector
	ORG		RESET_VECTOR+BLOADER_OFFSET+4
UserISR
	;retfie
	goto	UserInterrupt

;---------------------------------------------------------------------- 	
; USER PROGRAM STARTS HERE
;---------------------------------------------------------------------- 	

UserStart
Main
#DEFINE LED	PORTA,2			; LED 

	banksel	PORTA
	clrf	PORTA			
	clrf	PORTB			
	; set up option register
	bsf		STATUS,RP0		; Bank1
	movlw	B'00001000'
    ;         0-------  NOT RBPU: 0 = PORTB pull-ups are enabled by individual port latch values
    ;         -0------  INTEDG: 0 = Interrupt on rising edge of RB0/INT pin
    ;         --0-----  T0CS: 1 = Transition on GP2/T0CKI pin0=output,
    ;         ---0----  T0SE: 1 = Increment on high-to-low transition on /T0CKI pin not used, MCLR and reset
    ;         ----1---  PSA: 1 = Prescaler is assigned to the WDT
    ;         -----000  PS2:PS0: 111= 1:128 prescaler
	movwf	OPTION_REG
	bcf		LED				; TRISA output
	bcf		STATUS, RP0		; Bank0

	; Get blink frequency parameter from eeprom
	BANKSEL EEADR 		; Select Bank of EEADR 	
	movlw	EE_BLINK_F  ; 	
	movwf	EEADR 		; Data Memory Address 	
						; to read 	
	BANKSEL EECON1 		; Select Bank of EECON1 	
	bcf 	EECON1,EEPGD; Point to Data memory 	
	bsf 	EECON1,RD 	; EE Read 	
	BANKSEL EEDATA 		; Select Bank of EEDATA 	
	movf	EEDATA,W 	; W = EEDATA

	BANKSEL	PIR1	;select bank0
	movwf	blinkF	

MainLoop
	bsf	LED			   	; LED on			
	call 	delay	
	bcf	LED			   	; LED off			
	call 	delay	
	nop
	nop

	goto	MainLoop	; For Ever Loop------>

;------------------------- 	
; USER PROGRAM SUBROUTINES 
;------------------------- 	
delay
	movfw	blinkF
	movwf	cmpt3		
delay3
	clrf	cmpt2		
delay2
	clrf	cmpt1		
delay1
	nop					
	decfsz 	cmpt1, f	
	goto 	delay1		
	decfsz 	cmpt2, f	
	goto 	delay2		
	decfsz 	cmpt3, f	
	goto 	delay3		
	return

;------------------ 	
; INTERRUPT MANAGER
;------------------ 	
UserInterrupt
	;save register
	movwf	ISRwreg  		; WREG
	swapf	STATUS,w		; STATUS without change Z
	movwf	ISRstatus		; 
;restore register
UserInterrupt_end
	swapf	ISRstatus,w		; STATUS without change Z
	movwf   STATUS				
	swapf   ISRwreg,f		; WREG without change Z
 	swapf   ISRwreg,w  			
	retfie  				; return from interrupt set GIE

;---------------------------------------------------------------------- 	
; EEPROM                        
;---------------------------------------------------------------------- 	
	org 	EEPROM_DATA	

;----------------------------------------
;              Month Day   Year  Vnum
EE_VERSION	DE D'12',D'17',D'15',1,0,2
EE_SETTING	DE "chargePIC_led: TEST ONE BLINK LED ON RA2 PORT"
EE_BLINK_F  DE 0x01
;---------------------------------------------------------------------- 	
; END USER APPLICATION SEGMENT
;---------------------------------------------------------------------- 	


	END