﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace chargePIC
{
    #region Enums
    /// <summary>
    /// enumeration to hold our message types
    /// </summary>
    public enum MessageType { Data, Address, ASCII, Bootloader };
    #endregion

    public struct Word
    {
        public byte high;
        public byte low;

        public Word(byte h, byte l)
        {
            // TODO: Complete member initialization
            this.high = h;
            this.low = l;
        }

        public byte High { get { return high; } }
        public byte Low { get { return low; } }
        public string WordToString
        {
            get
            {
                return BitConverter.ToString(new byte[] { high, low }).Replace("-", "");
            }
        }
    }

    public struct MemInterval
    {
        private int min;
        private int max;

        public MemInterval(int min, int max)
        {
            this.min = min;
            this.max = max;
        }

        public int Min { get { return min; } }
        public int Max { get { return max; } }
    }

    class Memory
    {

        #region Properties

        /// <summary>
        /// Property to hold the BaudRate
        /// </summary>
        public int Index { get; set; }
        public Word[] Table { get; set; }

        public MemInterval[] ReadPlan { get; set; }
        public int RPlanIndex { get; set; }

        public MemInterval[] WritePlan { get; set; }
        public int WPlanIndex { get; set; }

        public bool TwoBytes { get; set; }

        #endregion

        private Color[] MessageColor = { Color.Blue, Color.Black, Color.Black, Color.Red };


        #region Constructors

        public Memory(int n, bool twoBytes = true) : this(n, new Word(0x3F, 0xFF), twoBytes) { }

        public Memory(int n, Word w, bool twoBytes = true)
        {
            Table = new Word[n];
            Populate(w);
            this.TwoBytes = twoBytes;
        }
        #endregion

        public void Populate(Word w)
        {
            for (int i = 0; i < Table.Length; i++)
            {
                Table[i].high = w.high;
                Table[i].low = w.low;
            }
        }

     }
}
