﻿using chargePIC.Properties;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace chargePIC
{
    public partial class TimeOutCalculForm : Form
    {
        internal bool altLine = false;

        private Settings settings = Settings.Default;

        public TimeOutCalculForm()
        {
            settings.Reload();

            InitializeComponent();
            // Restore the users settings
            InitializeControlValues();
        }

        private void ViewTimeOut(ListViewItem lvi)
        {
            TimeOutListView.Invoke(new EventHandler(delegate
            {
                lvi.UseItemStyleForSubItems = false; // for changing color of list view cell
                foreach (ListViewItem.ListViewSubItem si in lvi.SubItems)
                    if (altLine)
                        si.ForeColor = Color.Green; // color all columns
                TimeOutListView.Items.Add(lvi);
                altLine = !altLine;
            }));
        }

        private void TimeOutCalculate(float Fosc, int TO)
        {
            int ps;
            double timer;
            int timerOvf;
            double timeOut = TO;

            for (ps = 1; ps <= 8; ps = ps * 2)
            {
                //timeOut = TO;
                //if (timeOut < TO) break;
                for (timer = 0; timer < 65536; timer++)
                {
                    //if (timeOut > TO+0.05) break;
                    for (timerOvf = 1; timerOvf < 256; timerOvf++)
                    {
                        timeOut = ((1 / (Fosc / 4)) * ps * timer * timerOvf);
                        //if (timeOut < TO) break;
                        if (timeOut >= TO && timeOut < TO + 0.001)
                        {
                            ListViewItem lvi = new ListViewItem(string.Format("{0:0}", ps));
                            lvi.SubItems.Add(string.Format("{0:0}", 65535 - timer));
                            lvi.SubItems.Add(string.Format("{0:0}", timerOvf));
                            lvi.SubItems.Add(string.Format("{0:0.00}", timeOut));
                            ViewTimeOut(lvi);
                        }
                    }
                }
            }
        }

        private void InitializeControlValues()
        {
            FoscTextBox.Text = settings.OscillatorFrequency.ToString("0");
            TimeOutNumericUpDown.Value = settings.TimeOut;
            SaveChangesCheckBox.Checked = settings.SaveChangesTimeOut;
        }

        private void TimeOutCalculForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (SaveChangesCheckBox.Checked)
            {
                settings.OscillatorFrequency = float.Parse(FoscTextBox.Text);
                settings.TimeOut = TimeOutNumericUpDown.Value;
            }
            settings.SaveChangesTimeOut = SaveChangesCheckBox.Checked;
            settings.Save();

        }

        private void FoscTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            char keyChar;
            keyChar = e.KeyChar;

            if (!(Char.IsDigit(keyChar) // 0 - 9
               || keyChar == 8  // backspace
               || keyChar == 13  // enter
               ))
            {
                //  Do not display the keystroke
                e.Handled = true;
            }

        }

        private void TimeOutCalculButton_Click(object sender, EventArgs e)
        {
            if (FoscTextBox.Text.Trim() != "")
            {
                TimeOutListView.Items.Clear();
                TimeOutCalculate(float.Parse(FoscTextBox.Text), (int)TimeOutNumericUpDown.Value);
            }


        }
    }
}
